<div>
    <!-- Desktop/Tablet Version -->
    <div class="hidden md:flex min-h-screen w-full bg-gradient-to-br from-gray-50 via-white to-gray-100 dark:from-gray-900 dark:via-gray-800 dark:to-gray-900 p-4 sm:p-6 md:p-8">
        <!-- Animated background elements -->
        <div class="fixed top-20 left-20 w-24 h-24 bg-yellow-400/20 rounded-full animate-pulse"></div>
        <div class="fixed bottom-20 right-20 w-16 h-16 bg-yellow-500/20 rounded-full animate-bounce delay-300"></div>
        <div class="fixed top-1/3 right-1/4 w-12 h-12 bg-yellow-300/20 rounded-full animate-ping"></div>

        <div class="w-full max-w-md mx-auto animate-fadeIn flex items-center justify-center">
            <!-- Card Container -->
            <div class="relative bg-white dark:bg-gray-800 rounded-3xl shadow-xl p-8 border border-gray-100 dark:border-gray-700 transition-all duration-300 hover:shadow-2xl w-full">
                <!-- Decorative Elements -->
                <div class="absolute -top-8 -right-8 w-32 h-32 bg-yellow-400/20 dark:bg-yellow-600/10 rounded-full blur-3xl animate-pulse"></div>
                <div class="absolute -bottom-8 -left-8 w-32 h-32 bg-yellow-500/20 dark:bg-yellow-500/10 rounded-full blur-3xl animate-pulse delay-150"></div>
                
                <!-- Content -->
                <div class="relative">
                    <!-- Header with icon -->
                    <div class="text-center mb-8 animate-slideDown">
                        <div class="inline-flex items-center justify-center w-16 h-16 mb-4 rounded-full bg-yellow-100 dark:bg-yellow-900/30">
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-8 h-8 text-yellow-500 dark:text-yellow-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                            </svg>
                        </div>
                        <h1 class="text-2xl font-bold text-gray-900 dark:text-white mb-2">Security Check</h1>
                        <p class="text-gray-600 dark:text-gray-400">Please enter your 6-digit passcode to continue</p>
                    </div>

                    <form wire:submit.prevent="verify" class="space-y-6">
                        <!-- Passcode Input -->
                        <div class="animate-slideUp" style="animation-delay: 100ms;">
                            <div class="relative group">
                                <input 
                                    type="password"
                                    wire:model="passcode"
                                    maxlength="6"
                                    class="block w-full text-center text-2xl tracking-[1em] py-4 bg-gray-50 dark:bg-gray-700/50 border-2 border-gray-200 dark:border-gray-600 rounded-xl focus:ring-2 focus:ring-yellow-500 dark:focus:ring-yellow-600 focus:border-transparent dark:text-gray-200 transition-all duration-300 placeholder-gray-400 dark:placeholder-gray-500 group-hover:border-yellow-500 dark:group-hover:border-yellow-600"
                                    placeholder="••••••"
                                    inputmode="numeric"
                                    pattern="[0-9]*"
                                    autocomplete="off"
                                    required
                                    autofocus
                                >
                            </div>

                            <!--[if BLOCK]><![endif]--><?php if($error): ?>
                                <div class="mt-3 text-center text-red-500 dark:text-red-400 text-sm animate-shake">
                                    <?php echo e($error); ?>

                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <!-- Verify Button -->
                        <button
                            type="submit"
                            class="w-full px-4 py-3 text-sm font-medium text-white bg-yellow-500 hover:bg-yellow-600 dark:bg-yellow-600 dark:hover:bg-yellow-700 rounded-xl transition-all duration-300 transform hover:scale-[1.02] hover:shadow-lg focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-yellow-500 dark:focus:ring-offset-gray-800 group animate-slideUp"
                            style="animation-delay: 200ms;"
                        >
                            <span class="flex items-center justify-center">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2 transform transition-transform duration-300 group-hover:scale-110" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                                </svg>
                                Verify
                            </span>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Mobile Version -->
    <div class="md:hidden min-h-screen bg-gradient-to-b from-gray-50 to-gray-100 dark:from-gray-900 dark:to-gray-800">
        <!-- Back Button -->
        <div class="p-6">
            <a href="/" class="inline-flex items-center text-gray-600 dark:text-gray-400 hover:text-yellow-500 dark:hover:text-yellow-400 transition-colors duration-200">
                <svg class="w-6 h-6 transform transition-transform duration-200 hover:-translate-x-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
                </svg>
            </a>
        </div>

        <div class="flex flex-col items-center px-6 animate-fadeIn">
            <!-- Header -->
            <div class="text-center mb-8">
                <div class="inline-flex items-center justify-center w-16 h-16 mb-4 rounded-full bg-yellow-100 dark:bg-yellow-900/30">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-8 h-8 text-yellow-500 dark:text-yellow-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                    </svg>
                </div>
                <h1 class="text-2xl font-bold text-yellow-500 dark:text-yellow-400 mb-2">Enter Passcode</h1>
                <p class="text-sm text-gray-600 dark:text-gray-400">Passcode adds an extra layer of security</p>
            </div>

            <!-- Passcode Dots -->
            <div class="flex space-x-4 mb-8">
                <!--[if BLOCK]><![endif]--><?php for($i = 1; $i <= 6; $i++): ?>
                    <div class="w-3 h-3 rounded-full transition-all duration-300 transform <?php echo e(strlen($passcode) >= $i ? 'bg-yellow-500 dark:bg-yellow-400 scale-110' : 'bg-gray-300 dark:bg-gray-600'); ?>"></div>
                <?php endfor; ?><!--[if ENDBLOCK]><![endif]-->
            </div>

            <!--[if BLOCK]><![endif]--><?php if($error): ?>
                <div class="mb-6 text-center text-red-500 dark:text-red-400 text-sm animate-shake">
                    <?php echo e($error); ?>

                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

            <!-- Number Pad -->
            <div class="grid grid-cols-3 gap-4 mt-8">
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = range(1, 9); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $number): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <button 
                        wire:click="addNumber(<?php echo e($number); ?>)"
                        class="w-20 h-20 rounded-2xl bg-white dark:bg-gray-800 text-gray-800 dark:text-gray-200 text-2xl font-medium shadow-lg hover:shadow-xl transition-all duration-300 transform hover:scale-105 hover:bg-yellow-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-yellow-500 dark:focus:ring-yellow-500 active:scale-95">
                        <?php echo e($number); ?>

                    </button>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                
                <!-- Bottom Row -->
                <button 
                    wire:click="clearPasscode"
                    class="w-20 h-20 rounded-2xl bg-white dark:bg-gray-800 text-gray-800 dark:text-gray-200 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:scale-105 hover:bg-yellow-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-yellow-500 dark:focus:ring-yellow-500 active:scale-95">
                    <svg class="w-8 h-8 mx-auto" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2M3 12l6.414 6.414a2 2 0 001.414.586H19a2 2 0 002-2V7a2 2 0 00-2-2h-8.172a2 2 0 00-1.414.586L3 12z" />
                    </svg>
                </button>
                <button 
                    wire:click="addNumber(0)"
                    class="w-20 h-20 rounded-2xl bg-white dark:bg-gray-800 text-gray-800 dark:text-gray-200 text-2xl font-medium shadow-lg hover:shadow-xl transition-all duration-300 transform hover:scale-105 hover:bg-yellow-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-yellow-500 dark:focus:ring-yellow-500 active:scale-95">
                    0
                </button>
                <button 
                    wire:click="deleteNumber"
                    class="w-20 h-20 rounded-2xl bg-white dark:bg-gray-800 text-gray-800 dark:text-gray-200 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:scale-105 hover:bg-yellow-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-yellow-500 dark:focus:ring-yellow-500 active:scale-95">
                    <svg class="w-8 h-8 mx-auto" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2" />
                    </svg>
                </button>
            </div>
        </div>
    </div>

    <style>
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        @keyframes slideUp {
            from { transform: translateY(20px); opacity: 0; }
            to { transform: translateY(0); opacity: 1; }
        }
        @keyframes slideDown {
            from { transform: translateY(-20px); opacity: 0; }
            to { transform: translateY(0); opacity: 1; }
        }
        @keyframes shake {
            0%, 100% { transform: translateX(0); }
            25% { transform: translateX(-5px); }
            75% { transform: translateX(5px); }
        }
        .animate-fadeIn {
            animation: fadeIn 0.6s ease-out;
        }
        .animate-slideUp {
            opacity: 0;
            animation: slideUp 0.5s ease-out forwards;
        }
        .animate-slideDown {
            opacity: 0;
            animation: slideDown 0.5s ease-out forwards;
        }
        .animate-shake {
            animation: shake 0.5s ease-in-out;
        }
    </style>
</div><?php /**PATH /home/extraderminer/public_html/resources/views/livewire/auth/passcode-page.blade.php ENDPATH**/ ?>