<?php if (isset($component)) { $__componentOriginal951024bfcf58033c82ac11d797616473 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal951024bfcf58033c82ac11d797616473 = $attributes; } ?>
<?php $component = App\View\Components\UserLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\UserLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <main class="w-full mx-auto p-4 pb-24 md:pb-4 bg-gray-100 text-gray-900 dark:bg-gray-900 dark:text-white transition-all duration-300">
        <!-- Header -->
        <div class="flex items-center justify-between mb-8 pb-4">
            <a href="<?php echo e(url()->previous()); ?>" class="text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">
                <i class="fas fa-arrow-left text-xl"></i>
            </a>
            <h1 class="text-xl font-semibold text-center flex-1">Manage Crypto</h1>
            <div class="w-8"></div> <!-- Spacer for centering -->
        </div>
    
        <!-- Crypto List -->
        <div class="space-y-4">
            <?php $__currentLoopData = $cryptos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $crypto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="flex items-center justify-between p-4 crypto-item" data-crypto="<?php echo e(strtolower($crypto['symbol'])); ?>">
                    <div class="flex items-center">
                        <div class="w-10 h-10 rounded-full flex items-center justify-center mr-4">
                            <?php if(strtolower($crypto['symbol']) === 'usdt'): ?>
                                <!-- USDT Icon as Text -->
                                <span class="text-white font-bold">₮</span>
                            <?php else: ?>
                                <!-- Cryptocurrency Icon as Image -->
                                <img 
                                    src="<?php echo e(asset('images/' . strtolower($crypto['symbol']) . '-icon.png')); ?>" 
                                    alt="<?php echo e($crypto['name']); ?> Icon" 
                                    class="w-8 h-8 object-contain"
                                >
                            <?php endif; ?>
                        </div>
                        <div>
                            <h3 class="font-semibold"><?php echo e($crypto['symbol']); ?></h3>
                            <p class="text-sm text-gray-400"><?php echo e($crypto['name']); ?></p>
                        </div>
                    </div>
                    <div class="relative inline-flex items-center cursor-pointer">
                        <input 
    type="checkbox" 
    class="sr-only peer crypto-toggle" 
    <?php echo e($crypto['status'] === true ? 'checked' : ''); ?>

    data-crypto="<?php echo e(strtolower($crypto['symbol'])); ?>"
    id="crypto-toggle-<?php echo e(strtolower($crypto['symbol'])); ?>"
>
<label 
    for="crypto-toggle-<?php echo e(strtolower($crypto['symbol'])); ?>" 
    class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 dark:peer-focus:ring-blue-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-blue-600 cursor-pointer"
></label>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </main>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.crypto-toggle').forEach(checkbox => {
        checkbox.addEventListener('change', function() {
            const cryptoSymbol = this.getAttribute('data-crypto');
            const isChecked = this.checked;

            fetch('<?php echo e(route('crypto.manage.update')); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({
                    crypto: cryptoSymbol,
                    status: isChecked ? 1 : 0
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Create success message element if it doesn't exist
                    let successMsg = document.getElementById('crypto-success-message');
                    if (!successMsg) {
                        successMsg = document.createElement('div');
                        successMsg.id = 'crypto-success-message';
                        successMsg.className = 'fixed top-4 right-4 bg-green-500 text-white px-4 py-2 rounded shadow-lg z-50';
                        document.body.appendChild(successMsg);
                    }

                    // Set and show success message
                    successMsg.textContent = `Status updated successfully`;
                    successMsg.classList.remove('hidden');

                    // Automatically hide the message after 3 seconds
                    setTimeout(() => {
                        successMsg.classList.add('hidden');
                    }, 3000);
                } else {
                    // Revert the checkbox if update fails
                    this.checked = !isChecked;
                    
                    // Show error message
                    alert(data.message || 'Failed to update crypto status');
                }
            })
            .catch(error => {
                // Revert the checkbox
                this.checked = !isChecked;
                
                alert('An error occurred while updating crypto status');
            });
        });
    });
});
</script>
<?php $__env->stopPush(); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $attributes = $__attributesOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__attributesOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $component = $__componentOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__componentOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?><?php /**PATH /home/cypherva/public_html/resources/views/user/crypto/manage.blade.php ENDPATH**/ ?>