<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
   <title><?php echo e((setting('site_name'))); ?></title>
    <link rel="icon" href="<?php echo e(asset(setting('site_favicon'))); ?>" type="image/x-icon">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    colors: {
                        purple: {
                            600: '#9333ea',
                            700: '#7e22ce',
                        },
                        pink: {
                            600: '#db2777',
                            700: '#be185d',
                        },
                    },
                },
            },
        }
    </script>
    <style>
    @keyframes spin-slow {
        from { transform: rotate(0deg); }
        to { transform: rotate(360deg); }
    }
    @keyframes spin-slow-reverse {
        from { transform: rotate(360deg); }
        to { transform: rotate(0deg); }
    }
    .animate-spin-slow {
        animation: spin-slow 20s linear infinite;
    }
    .animate-spin-slow-reverse {
        animation: spin-slow-reverse 15s linear infinite;
    }
</style>
</head>
<body class="bg-gradient-to-br from-white to-gray-100 dark:from-gray-900 dark:to-gray-800 text-gray-900 dark:text-white transition-colors duration-300">
    <header class="container mx-auto px-4 py-6 flex justify-between items-center">
        <h1 class="text-3xl font-bold text-transparent bg-clip-text bg-gradient-to-r from-purple-600 to-pink-600">Blockcino</h1>
        <nav class="hidden md:flex space-x-6">
            <a href="#features" class="hover:text-purple-600 transition-colors">Features</a>
            <a href="#security" class="hover:text-purple-600 transition-colors">Security</a>
        </nav>
        <div class="flex items-center space-x-4">
            <!-- Auth buttons -->
            <?php if(auth()->guard()->check()): ?>
                <a href="<?php echo e(route('dashboard')); ?>">
                    <button class="bg-purple-600 hover:bg-purple-700 text-white font-bold py-2 px-4 rounded-full text-sm transition-colors duration-300">
                        Open Wallet
                    </button>
                </a>
            <?php else: ?>
                <a href="<?php echo e(route('login')); ?>">
                    <button class="bg-purple-600 hover:bg-purple-700 text-white font-bold py-2 px-4 rounded-full text-sm transition-colors duration-300">
                        Access Wallet
                    </button>
                </a>
            <?php endif; ?>
            <!-- Dark mode toggle -->
            <button id="darkModeToggle" class="p-2 rounded-full bg-gray-200 dark:bg-gray-700 text-gray-800 dark:text-gray-200">
                <svg id="sunIcon" xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z" />
                </svg>
                <svg id="moonIcon" xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 hidden" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 11.5a8.38 8.38 0 01-.9 3.807 8.38 8.38 0 01-3.8.9L12 18.354l-1.121.523a8.38 8.38 0 01-3.8-.9 8.38 8.38 0 01-.9-3.807 8.38 8.38 0 013.8-3.807 8.38 8.38 0 013.8-.9l1.121.523zm-2.958-7.919a16.128 16.128 0 013.1 2.66 4.35 4.35 0 01-.832 2.94c.07.152.4.923.8.923h.005c.4 0 .75-.77.8-.923 3.183-1.651 6.817-1.651 10 0a4.35 4.35 0 01-.832 2.94 16.128 16.128 0 013.1 2.66A10.54 10.54 0 0112 15.69l-1.121-.523a10.54 10.54 0 01-3.8-.9 10.54 10.54 0 01-3.8-3.807 10.54 10.54 0 013.8-3.807 10.54 10.54 0 013.8-.9l1.121.523z" />
                </svg>
            </button>
        </div>
    </header>
    <main class="container mx-auto px-4 py-4">
    <section id="hero" class="relative mb-24">
        <!-- Decorative background elements -->
        <div class="absolute top-0 right-0 w-72 h-72 bg-purple-600/10 rounded-full blur-3xl"></div>
        <div class="absolute bottom-0 left-0 w-72 h-72 bg-pink-600/10 rounded-full blur-3xl"></div>
        
        <!-- Hero content -->
        <div class="relative z-10 flex flex-col lg:flex-row items-center justify-between gap-12">
            <!-- Left column - Text content -->
            <div class="flex-1 text-center lg:text-left">
                <h2 class="text-5xl md:text-7xl font-bold mb-6">
                    Your <span class="text-transparent bg-clip-text bg-gradient-to-r from-purple-600 to-pink-600">Universal</span> 
                    Wallet
                </h2>
                <p class="text-xl md:text-2xl mb-8 text-gray-600 dark:text-gray-300">
                    One secure wallet for all your digital assets. Trade and manage your portfolio with confidence.
                </p>
                
                <!-- CTA buttons -->
                <div class="flex flex-col sm:flex-row justify-center lg:justify-start gap-4">
                    <a href="<?php echo e(route('register')); ?>">
                    <button class="px-8 py-4 bg-gradient-to-r from-purple-600 to-pink-600 text-white font-semibold rounded-full hover:opacity-90 transform transition-all duration-300 hover:scale-105 shadow-lg hover:shadow-xl">
                        Create Free Wallet
                    </button>
                    </a>
                </div>

                <!-- Stats -->
                <div class="mt-12 grid grid-cols-3 gap-8">
                    <div class="text-center">
                        <div class="text-3xl font-bold text-purple-600">$2B+</div>
                        <div class="text-sm text-gray-600 dark:text-gray-400">Assets Managed</div>
                    </div>
                    <div class="text-center">
                        <div class="text-3xl font-bold text-pink-600">1M+</div>
                        <div class="text-sm text-gray-600 dark:text-gray-400">Active Users</div>
                    </div>
                    <div class="text-center">
                        <div class="text-3xl font-bold text-purple-600">150+</div>
                        <div class="text-sm text-gray-600 dark:text-gray-400">Supported Coins</div>
                    </div>
                </div>
            </div>

            <!-- Right column - Wallet Preview -->
            <div class="flex-1 relative">
                <div class="relative bg-white dark:bg-gray-800 rounded-2xl shadow-2xl p-6 transform transition-all duration-300 hover:scale-105">
                    <!-- Wallet interface mockup -->
                    <div class="flex items-center justify-between mb-6">
                        <div class="flex items-center space-x-3">
                            <div class="w-10 h-10 bg-gradient-to-r from-purple-600 to-pink-600 rounded-full"></div>
                            <div>
                                <div class="font-semibold">Total Balance</div>
                                <div class="text-sm text-gray-600 dark:text-gray-400">Updated just now</div>
                            </div>
                        </div>
                        <div class="text-2xl font-bold">$25,432.95</div>
                    </div>
                    
                    <!-- Asset list preview -->
                    <div class="space-y-4">
                        <div class="flex items-center justify-between p-3 bg-gray-50 dark:bg-gray-700 rounded-xl">
                            <div class="flex items-center space-x-3">
                                <div class="w-8 h-8 bg-yellow-500 rounded-full flex items-center justify-center text-white font-bold text-sm">₿</div>
                                <div>Bitcoin</div>
                            </div>
                            <div class="text-right">
                                <div class="font-semibold">0.45 BTC</div>
                                <div class="text-sm text-green-500">+3.54%</div>
                            </div>
                        </div>
                        <div class="flex items-center justify-between p-3 bg-gray-50 dark:bg-gray-700 rounded-xl">
                            <div class="flex items-center space-x-3">
                                <div class="w-8 h-8 bg-blue-500 rounded-full flex items-center justify-center text-white font-bold text-sm">Ξ</div>
                                <div>Ethereum</div>
                            </div>
                            <div class="text-right">
                                <div class="font-semibold">4.21 ETH</div>
                                <div class="text-sm text-green-500">+5.23%</div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Decorative elements -->
                <div class="absolute -top-4 -right-4 w-24 h-24 bg-purple-600/20 rounded-full blur-xl"></div>
                <div class="absolute -bottom-4 -left-4 w-24 h-24 bg-pink-600/20 rounded-full blur-xl"></div>
            </div>
        </div>
    </section>
                    <section id="features" class="mb-24">
    <div class="text-center mb-16">
        <h2 class="text-3xl md:text-4xl font-bold mb-4">
            Powerful Features for Your 
            <span class="text-transparent bg-clip-text bg-gradient-to-r from-purple-600 to-pink-600">Digital Assets</span>
        </h2>
        <p class="text-xl text-gray-600 dark:text-gray-400 max-w-3xl mx-auto">
            Everything you need to manage your cryptocurrency portfolio in one secure platform
        </p>
    </div>

    <!-- Features grid -->
    <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
        <!-- Multi-Chain Support -->
        <div class="bg-white dark:bg-gray-800 rounded-2xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:scale-[1.02]">
            <div class="w-12 h-12 bg-purple-100 dark:bg-purple-900/30 rounded-lg flex items-center justify-center mb-6">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-purple-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 12a9 9 0 01-9 9m9-9a9 9 0 00-9-9m9 9H3m9 9a9 9 0 01-9-9m9 9c1.657 0 3-4.03 3-9s-1.343-9-3-9m0 18c-1.657 0-3-4.03-3-9s1.343-9 3-9m-9 9a9 9 0 019-9" />
                </svg>
            </div>
            <h3 class="text-xl font-semibold mb-3">Multi-Chain Support</h3>
            <p class="text-gray-600 dark:text-gray-400 mb-4">
                Support for multiple blockchains including Ethereum, Binance Smart Chain, Polygon, and more.
            </p>
            <div class="flex flex-wrap gap-2">
                <span class="px-3 py-1 bg-purple-100 dark:bg-purple-900/30 text-purple-600 rounded-full text-sm">Ethereum</span>
                <span class="px-3 py-1 bg-purple-100 dark:bg-purple-900/30 text-purple-600 rounded-full text-sm">BSC</span>
                <span class="px-3 py-1 bg-purple-100 dark:bg-purple-900/30 text-purple-600 rounded-full text-sm">Polygon</span>
            </div>
        </div>

        <!-- DeFi Integration -->
        <div class="bg-white dark:bg-gray-800 rounded-2xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:scale-[1.02]">
            <div class="w-12 h-12 bg-pink-100 dark:bg-pink-900/30 rounded-lg flex items-center justify-center mb-6">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-pink-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
            </div>
            <h3 class="text-xl font-semibold mb-3">DeFi Integration</h3>
            <p class="text-gray-600 dark:text-gray-400 mb-4">
                Direct access to decentralized exchanges, lending platforms, and yield farming opportunities.
            </p>
            <div class="flex flex-wrap gap-2">
                <span class="px-3 py-1 bg-pink-100 dark:bg-pink-900/30 text-pink-600 rounded-full text-sm">Swap</span>
                <span class="px-3 py-1 bg-pink-100 dark:bg-pink-900/30 text-pink-600 rounded-full text-sm">Stake</span>
                <span class="px-3 py-1 bg-pink-100 dark:bg-pink-900/30 text-pink-600 rounded-full text-sm">Farm</span>
            </div>
        </div>

        <!-- Advanced Security -->
        <div class="bg-white dark:bg-gray-800 rounded-2xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:scale-[1.02]">
            <div class="w-12 h-12 bg-purple-100 dark:bg-purple-900/30 rounded-lg flex items-center justify-center mb-6">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-purple-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                </svg>
            </div>
            <h3 class="text-xl font-semibold mb-3">Advanced Security</h3>
            <p class="text-gray-600 dark:text-gray-400 mb-4">
                Enterprise-grade security with multi-sig support, hardware wallet integration, and biometric authentication.
            </p>
            <div class="flex flex-wrap gap-2">
                <span class="px-3 py-1 bg-purple-100 dark:bg-purple-900/30 text-purple-600 rounded-full text-sm">2FA</span>
                <span class="px-3 py-1 bg-purple-100 dark:bg-purple-900/30 text-purple-600 rounded-full text-sm">Multi-sig</span>
                <span class="px-3 py-1 bg-purple-100 dark:bg-purple-900/30 text-purple-600 rounded-full text-sm">Biometric</span>
            </div>
        </div>

        <!-- Portfolio Tracking -->
        <div class="bg-white dark:bg-gray-800 rounded-2xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:scale-[1.02]">
            <div class="w-12 h-12 bg-pink-100 dark:bg-pink-900/30 rounded-lg flex items-center justify-center mb-6">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-pink-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 12l3-3 3 3 4-4M8 21l4-4 4 4M3 4h18M4 4h16v12a1 1 0 01-1 1H5a1 1 0 01-1-1V4z" />
                </svg>
            </div>
            <h3 class="text-xl font-semibold mb-3">Portfolio Tracking</h3>
            <p class="text-gray-600 dark:text-gray-400 mb-4">
                Real-time portfolio monitoring with price alerts, performance analytics, and tax reporting tools.
            </p>
            <div class="flex flex-wrap gap-2">
                <span class="px-3 py-1 bg-pink-100 dark:bg-pink-900/30 text-pink-600 rounded-full text-sm">Analytics</span>
                <span class="px-3 py-1 bg-pink-100 dark:bg-pink-900/30 text-pink-600 rounded-full text-sm">Alerts</span>
                <span class="px-3 py-1 bg-pink-100 dark:bg-pink-900/30 text-pink-600 rounded-full text-sm">Reports</span>
            </div>
        </div>

        <!-- NFT Support -->
        <div class="bg-white dark:bg-gray-800 rounded-2xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:scale-[1.02]">
            <div class="w-12 h-12 bg-purple-100 dark:bg-purple-900/30 rounded-lg flex items-center justify-center mb-6">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-purple-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                </svg>
            </div>
            <h3 class="text-xl font-semibold mb-3">NFT Support</h3>
            <p class="text-gray-600 dark:text-gray-400 mb-4">
                Store, view, and manage your NFT collection with support for multiple marketplaces and chains.
            </p>
            <div class="flex flex-wrap gap-2">
                <span class="px-3 py-1 bg-purple-100 dark:bg-purple-900/30 text-purple-600 rounded-full text-sm">Gallery</span>
                <span class="px-3 py-1 bg-purple-100 dark:bg-purple-900/30 text-purple-600 rounded-full text-sm">Trading</span>
                <span class="px-3 py-1 bg-purple-100 dark:bg-purple-900/30 text-purple-600 rounded-full text-sm">Tracking</span>
            </div>
        </div>

        <!-- Cross-Platform -->
        <div class="bg-white dark:bg-gray-800 rounded-2xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:scale-[1.02]">
            <div class="w-12 h-12 bg-pink-100 dark:bg-pink-900/30 rounded-lg flex items-center justify-center mb-6">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-pink-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.75 17L9 20l-1 1h8l-1-1-.75-3M3 13h18M5 17h14a2 2 0 002-2V5a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                </svg>
            </div>
            <h3 class="text-xl font-semibold mb-3">Cross-Platform</h3>
            <p class="text-gray-600 dark:text-gray-400 mb-4">
                Access your wallet seamlessly across desktop, mobile, and browser extension platforms.
            </p>
            <div class="flex flex-wrap gap-2">
                <span class="px-3 py-1 bg-pink-100 dark:bg-pink-900/30 text-pink-600 rounded-full text-sm">Desktop</span>
                <span class="px-3 py-1 bg-pink-100 dark:bg-pink-900/30 text-pink-600 rounded-full text-sm">Mobile</span>
                <span class="px-3 py-1 bg-pink-100 dark:bg-pink-900/30 text-pink-600 rounded-full text-sm">Extension</span>
            </div>
        </div>
    </div>
</section>
<section id="security" class="mb-24 relative">
    <!-- Decorative background elements -->
    <div class="absolute top-0 right-0 w-96 h-96 bg-purple-600/5 rounded-full blur-3xl -z-10"></div>
    <div class="absolute bottom-0 left-0 w-96 h-96 bg-pink-600/5 rounded-full blur-3xl -z-10"></div>

    <!-- Section header -->
    <div class="text-center mb-16">
        <h2 class="text-3xl md:text-4xl font-bold mb-4">
            Bank-Grade <span class="text-transparent bg-clip-text bg-gradient-to-r from-purple-600 to-pink-600">Security</span> Protocols
        </h2>
        <p class="text-xl text-gray-600 dark:text-gray-400 max-w-3xl mx-auto">
            Your assets are protected by multiple layers of cutting-edge security measures
        </p>
    </div>

    <!-- Security features grid -->
    <div class="grid lg:grid-cols-2 gap-8 mb-12">
        <!-- Security visualization card -->
        <div class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-lg">
            <div class="relative h-full min-h-[400px] flex items-center justify-center">
                <!-- Animated security layers visualization -->
                <div class="relative w-64 h-64">
                    <!-- Outer layer -->
                    <div class="absolute inset-0 rounded-full border-4 border-dashed border-purple-200 dark:border-purple-900 animate-spin-slow"></div>
                    <!-- Middle layer -->
                    <div class="absolute inset-8 rounded-full border-4 border-dashed border-pink-200 dark:border-pink-900 animate-spin-slow-reverse"></div>
                    <!-- Inner layer -->
                    <div class="absolute inset-16 rounded-full bg-gradient-to-br from-purple-600/20 to-pink-600/20 flex items-center justify-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12 text-purple-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                        </svg>
                    </div>
                </div>
                
                <!-- Security indicators -->
                <div class="absolute inset-0">
                    <!-- Encryption indicator -->
                    <div class="absolute top-12 left-0 flex items-center">
                        <div class="w-3 h-3 bg-green-500 rounded-full animate-pulse"></div>
                        <span class="ml-2 text-sm text-gray-600 dark:text-gray-400">End-to-End Encryption</span>
                    </div>
                    <!-- Firewall indicator -->
                    <div class="absolute top-1/2 right-0 flex items-center">
                        <div class="w-3 h-3 bg-blue-500 rounded-full animate-pulse"></div>
                        <span class="ml-2 text-sm text-gray-600 dark:text-gray-400">Advanced Firewall</span>
                    </div>
                    <!-- Monitoring indicator -->
                    <div class="absolute bottom-12 left-0 flex items-center">
                        <div class="w-3 h-3 bg-purple-500 rounded-full animate-pulse"></div>
                        <span class="ml-2 text-sm text-gray-600 dark:text-gray-400">24/7 Monitoring</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Security features list -->
        <div class="space-y-6">
            <div class="bg-white dark:bg-gray-800 rounded-xl p-6 shadow-lg transform transition-all duration-300 hover:scale-[1.02]">
                <div class="flex items-center mb-4">
                    <div class="w-10 h-10 bg-purple-100 dark:bg-purple-900/30 rounded-lg flex items-center justify-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-purple-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                        </svg>
                    </div>
                    <h3 class="ml-4 text-lg font-semibold">Military-Grade Encryption</h3>
                </div>
                <p class="text-gray-600 dark:text-gray-400">
                    Your private keys are encrypted using AES-256 encryption, the same standard used by military and financial institutions.
                </p>
            </div>

            <div class="bg-white dark:bg-gray-800 rounded-xl p-6 shadow-lg transform transition-all duration-300 hover:scale-[1.02]">
                <div class="flex items-center mb-4">
                    <div class="w-10 h-10 bg-pink-100 dark:bg-pink-900/30 rounded-lg flex items-center justify-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-pink-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                        </svg>
                    </div>
                    <h3 class="ml-4 text-lg font-semibold">Multi-Factor Authentication</h3>
                </div>
                <p class="text-gray-600 dark:text-gray-400">
                    Enhanced security with optional biometric authentication, hardware key support, and time-based OTP.
                </p>
            </div>

            <div class="bg-white dark:bg-gray-800 rounded-xl p-6 shadow-lg transform transition-all duration-300 hover:scale-[1.02]">
                <div class="flex items-center mb-4">
                    <div class="w-10 h-10 bg-purple-100 dark:bg-purple-900/30 rounded-lg flex items-center justify-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-purple-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                        </svg>
                    </div>
                    <h3 class="ml-4 text-lg font-semibold">Smart Contract Auditing</h3>
                </div>
                <p class="text-gray-600 dark:text-gray-400">
                    Automatic scanning and verification of smart contracts before interaction to prevent malicious transactions.
                </p>
            </div>

            <div class="bg-white dark:bg-gray-800 rounded-xl p-6 shadow-lg transform transition-all duration-300 hover:scale-[1.02]">
                <div class="flex items-center mb-4">
                    <div class="w-10 h-10 bg-pink-100 dark:bg-pink-900/30 rounded-lg flex items-center justify-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-pink-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8" />
                        </svg>
                    </div>
                    <h3 class="ml-4 text-lg font-semibold">Cold Storage Backup</h3>
                </div>
                <p class="text-gray-600 dark:text-gray-400">
                    Automated backup of your wallet to secure cold storage facilities with geographic distribution.
                </p>
            </div>
        </div>
    </div>
</section>
    
                <footer class="bg-white dark:bg-gray-800 pt-16 pb-12">
    <div class="container mx-auto px-4">
        <!-- Footer grid -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-12 mb-16">
            <!-- Company info -->
            <div class="space-y-4">
                <h3 class="text-2xl font-bold text-transparent bg-clip-text bg-gradient-to-r from-purple-600 to-pink-600">
                    Blockcino
                </h3>
                <p class="text-gray-600 dark:text-gray-400">
                    Secure, reliable, and user-friendly crypto wallet for the next generation of digital finance.
                </p>
                <div class="flex space-x-4">
                    <a href="#" class="text-gray-400 hover:text-purple-600 transition-colors">
                        <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true">
                            <path d="M8.29 20.251c7.547 0 11.675-6.253 11.675-11.675 0-.178 0-.355-.012-.53A8.348 8.348 0 0022 5.92a8.19 8.19 0 01-2.357.646 4.118 4.118 0 001.804-2.27 8.224 8.224 0 01-2.605.996 4.107 4.107 0 00-6.993 3.743 11.65 11.65 0 01-8.457-4.287 4.106 4.106 0 001.27 5.477A4.072 4.072 0 012.8 9.713v.052a4.105 4.105 0 003.292 4.022 4.095 4.095 0 01-1.853.07 4.108 4.108 0 003.834 2.85A8.233 8.233 0 012 18.407a11.616 11.616 0 006.29 1.84"></path>
                        </svg>
                    </a>
                    <a href="#" class="text-gray-400 hover:text-purple-600 transition-colors">
                        <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true">
                            <path fill-rule="evenodd" d="M12 2C6.477 2 2 6.484 2 12.017c0 4.425 2.865 8.18 6.839 9.504.5.092.682-.217.682-.483 0-.237-.008-.868-.013-1.703-2.782.605-3.369-1.343-3.369-1.343-.454-1.158-1.11-1.466-1.11-1.466-.908-.62.069-.608.069-.608 1.003.07 1.531 1.032 1.531 1.032.892 1.53 2.341 1.088 2.91.832.092-.647.35-1.088.636-1.338-2.22-.253-4.555-1.113-4.555-4.951 0-1.093.39-1.988 1.029-2.688-.103-.253-.446-1.272.098-2.65 0 0 .84-.27 2.75 1.026A9.564 9.564 0 0112 6.844c.85.004 1.705.115 2.504.337 1.909-1.296 2.747-1.027 2.747-1.027.546 1.379.202 2.398.1 2.651.64.7 1.028 1.595 1.028 2.688 0 3.848-2.339 4.695-4.566 4.943.359.309.678.92.678 1.855 0 1.338-.012 2.419-.012 2.747 0 .268.18.58.688.482A10.019 10.019 0 0022 12.017C22 6.484 17.522 2 12 2z" clip-rule="evenodd"></path>
                        </svg>
                    </a>
                    <a href="#" class="text-gray-400 hover:text-purple-600 transition-colors">
                        <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true">
                            <path fill-rule="evenodd" d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10c5.51 0 10-4.48 10-10S17.51 2 12 2zm6.605 4.61a8.502 8.502 0 011.93 5.314c-.281-.054-3.101-.629-5.943-.271-.065-.141-.12-.293-.184-.445a25.416 25.416 0 00-.564-1.236c3.145-1.28 4.577-3.124 4.761-3.362zM12 3.475c2.17 0 4.154.813 5.662 2.148-.152.216-1.443 1.941-4.48 3.08-1.399-2.57-2.95-4.675-3.189-5A8.687 8.687 0 0112 3.475zm-3.633.803a53.896 53.896 0 013.167 4.935c-3.992 1.063-7.517 1.04-7.896 1.04a8.581 8.581 0 014.729-5.975zM3.453 12.01v-.26c.37.01 4.512.065 8.775-1.215.25.477.477.965.694 1.453-.109.033-.228.065-.336.098-4.404 1.42-6.747 5.303-6.942 5.629a8.522 8.522 0 01-2.19-5.705zM12 20.547a8.482 8.482 0 01-5.239-1.8c.152-.315 1.888-3.656 6.703-5.337.022-.01.033-.01.054-.022a35.318 35.318 0 011.823 6.475 8.4 8.4 0 01-3.341.684zm4.761-1.465c-.086-.52-.542-3.015-1.659-6.084 2.679-.423 5.022.271 5.314.369a8.468 8.468 0 01-3.655 5.715z" clip-rule="evenodd"></path>
                        </svg>
                    </a>
                </div>
            </div>

            <!-- Quick Links -->
            <div>
                <h4 class="text-lg font-semibold mb-4">Quick Links</h4>
                <ul class="space-y-3">
                    <li>
                        <a href="#features" class="text-gray-600 dark:text-gray-400 hover:text-purple-600 dark:hover:text-purple-400 transition-colors">Features</a>
                    </li>
                    <li>
                        <a href="#security" class="text-gray-600 dark:text-gray-400 hover:text-purple-600 dark:hover:text-purple-400 transition-colors">Security</a>
                    </li>
                    <li>
                        <a href="#staking" class="text-gray-600 dark:text-gray-400 hover:text-purple-600 dark:hover:text-purple-400 transition-colors">Staking</a>
                    </li>
                    <li>
                        <a href="#assets" class="text-gray-600 dark:text-gray-400 hover:text-purple-600 dark:hover:text-purple-400 transition-colors">Supported Assets</a>
                    </li>
                </ul>
            </div>

            <!-- Support -->
            <div>
                <h4 class="text-lg font-semibold mb-4">Support</h4>
                <ul class="space-y-3">
                    <li>
                        <a href="#" class="text-gray-600 dark:text-gray-400 hover:text-purple-600 dark:hover:text-purple-400 transition-colors">Help Center</a>
                    </li>
                    <li>
                        <a href="#" class="text-gray-600 dark:text-gray-400 hover:text-purple-600 dark:hover:text-purple-400 transition-colors">Documentation</a>
                    </li>
                    <li>
                        <a href="#" class="text-gray-600 dark:text-gray-400 hover:text-purple-600 dark:hover:text-purple-400 transition-colors">API Reference</a>
                    </li>
                    <li>
                        <a href="#" class="text-gray-600 dark:text-gray-400 hover:text-purple-600 dark:hover:text-purple-400 transition-colors">Status</a>
                    </li>
                </ul>
            </div>

            <!-- Newsletter -->
            <div>
                <h4 class="text-lg font-semibold mb-4">Stay Updated</h4>
                <p class="text-gray-600 dark:text-gray-400 mb-4">
                    Subscribe to our newsletter for the latest updates and features.
                </p>
                <form class="space-y-3">
                    <div class="relative">
                        <input 
                            type="email" 
                            placeholder="Enter your email"
                            class="w-full bg-gray-50 dark:bg-gray-700 border border-gray-200 dark:border-gray-600 rounded-xl px-4 py-3 focus:ring-2 focus:ring-purple-600 focus:border-transparent"
                        >
                    </div>
                    <button type="submit" class="w-full py-3 px-4 bg-gradient-to-r from-purple-600 to-pink-600 text-white rounded-xl font-medium hover:opacity-90 transition-opacity">
                        Subscribe
                    </button>
                </form>
            </div>
        </div>

        <!-- Divider -->
        <div class="border-t border-gray-200 dark:border-gray-700 pt-8">
            <div class="flex flex-col md:flex-row justify-between items-center space-y-4 md:space-y-0">
                <!-- Copyright -->
                <div class="text-gray-600 dark:text-gray-400">
                    © 2024 Blockcino. All rights reserved.
                </div>

                <!-- Legal links -->
                <div class="flex space-x-6">
                    <a href="#" class="text-gray-600 dark:text-gray-400 hover:text-purple-600 dark:hover:text-purple-400 text-sm transition-colors">
                        Privacy Policy
                    </a>
                    <a href="#" class="text-gray-600 dark:text-gray-400 hover:text-purple-600 dark:hover:text-purple-400 text-sm transition-colors">
                        Terms of Service
                    </a>
                    <a href="#" class="text-gray-600 dark:text-gray-400 hover:text-purple-600 dark:hover:text-purple-400 text-sm transition-colors">
                        Cookie Policy
                    </a>
                </div>
            </div>
        </div>
    </div>
</footer>
                     <script>
        const darkModeToggle = document.getElementById('darkModeToggle');
        const html = document.documentElement;
        const moonIcon = document.getElementById('moonIcon');
        const sunIcon = document.getElementById('sunIcon');

        // Function to set the theme
        function setTheme(isDark) {
            html.classList.toggle('dark', isDark);
            moonIcon.classList.toggle('hidden', !isDark);
            sunIcon.classList.toggle('hidden', isDark);
        }

        // Check for saved theme preference or use system preference
        const darkModeMediaQuery = window.matchMedia('(prefers-color-scheme: dark)');
        const hasUserPreference = localStorage.getItem('theme');

        if (hasUserPreference) {
            setTheme(hasUserPreference === 'dark');
        } else {
            setTheme(darkModeMediaQuery.matches);
        }

        // Toggle theme and save preference
        darkModeToggle.addEventListener('click', () => {
            const isDark = html.classList.toggle('dark');
            setTheme(isDark);
            localStorage.setItem('theme', isDark ? 'dark' : 'light');
        });

        // Listen for system theme changes
        darkModeMediaQuery.addListener((e) => {
            if (!hasUserPreference) {
                setTheme(e.matches);
            }
        });
    </script>
    
  
    
    
    </body>
</html><?php /**PATH /home/blockcino/public_html/resources/views/welcome.blade.php ENDPATH**/ ?>