<div>
    <!-- Desktop/Tablet Version -->
   <div class="hidden md:flex min-h-screen w-full bg-gradient-to-br from-gray-50 via-white to-gray-100 dark:from-gray-900 dark:via-gray-800 dark:to-gray-900 p-4 sm:p-6 md:p-8">
    <div class="w-full max-w-lg px-6 mx-auto flex items-center justify-center">
        <!-- Card Container -->
        <div class="w-full bg-white dark:bg-gray-800 rounded-2xl shadow-lg p-8">
            <div class="text-center mb-8">
                <h3 class="text-xl font-semibold text-gray-900 dark:text-gray-100">
                    <?php echo e($step === 1 ? 'Create Passcode' : 'Confirm Passcode'); ?>

                </h3>
                <p class="mt-2 text-sm text-gray-600 dark:text-gray-400">
                    <?php echo e($step === 1 
                        ? 'Enter a 6-digit passcode to secure your account' 
                        : 'Re-enter your passcode to confirm'); ?>

                </p>
            </div>

            <form wire:submit.prevent="verifyAndSave" class="space-y-6">
                <!-- Hidden Input -->
                <div>
                    <input 
                        type="password"
                        wire:model="<?php echo e($step === 1 ? 'passcode' : 'confirmPasscode'); ?>"
                        maxlength="6"
                        class="block w-full text-center text-2xl tracking-[1em] bg-gray-50 dark:bg-gray-900 border border-gray-300 dark:border-gray-600 text-gray-800 dark:text-gray-200 rounded-lg focus:ring-2 focus:ring-yellow-500 dark:focus:ring-yellow-500 focus:border-transparent"
                        placeholder="••••••"
                        inputmode="numeric"
                        pattern="[0-9]*"
                        autocomplete="off"
                        required
                        autofocus
                    >
                </div>

                <!--[if BLOCK]><![endif]--><?php if($error): ?>
                    <p class="text-sm text-center text-red-500 dark:text-red-400"><?php echo e($error); ?></p>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                <div class="mt-8 flex justify-end space-x-3">
                    <!--[if BLOCK]><![endif]--><?php if($step === 2): ?>
                        <button 
                            type="button"
                            wire:click="goBack"
                            class="px-6 py-2 text-sm font-medium text-gray-700 dark:text-gray-300 bg-gray-100 dark:bg-gray-700 rounded-lg hover:bg-gray-200 dark:hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gray-500 focus:ring-offset-gray-800"
                        >
                            Back
                        </button>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    <button 
                        type="submit"
                        class="px-6 py-2 text-sm font-medium text-white bg-yellow-600 dark:bg-yellow-500 rounded-lg hover:bg-yellow-700 dark:hover:bg-yellow-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-yellow-500 focus:ring-offset-gray-800"
                    >
                        <?php echo e($step === 1 ? 'Next' : 'Set Passcode'); ?>

                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
                    <!-- Mobile Version -->
                    <div class="md:hidden min-h-screen bg-gradient-to-b from-gray-50 to-gray-100 dark:from-gray-900 dark:to-gray-800">
    <!-- Back Button -->
    <div class="p-4">
        <!--[if BLOCK]><![endif]--><?php if($step === 2): ?>
            <button 
                wire:click="goBack" 
                class="text-gray-400 dark:text-gray-400 hover:text-gray-300 dark:hover:text-gray-300"
            >
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
                </svg>
            </button>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    </div>

    <div class="flex flex-col items-center px-6">
        <!-- Title -->
        <h1 class="text-xl font-bold text-yellow-500 dark:text-yellow-400">
            <?php echo e($step === 1 ? 'Create passcode' : 'Confirm passcode'); ?>

        </h1>

        <!-- Dots -->
        <div class="flex space-x-3 mt-6">
            <!--[if BLOCK]><![endif]--><?php for($i = 1; $i <= 6; $i++): ?>
                <div class="w-2 h-2 rounded-full <?php echo e(strlen($step === 1 ? $passcode : $confirmPasscode) >= $i 
                        ? 'bg-yellow-500 dark:bg-yellow-500' 
                        : 'bg-gray-600 dark:bg-gray-600'); ?>"></div>
            <?php endfor; ?><!--[if ENDBLOCK]><![endif]-->
        </div>

        <!-- Subtitle -->
        <p class="mt-4 text-sm text-center text-gray-500 dark:text-gray-400">
            <?php echo e($step === 1 
                ? 'Enter a 6-digit passcode to secure your account' 
                : 'Re-enter your passcode to confirm'); ?>

        </p>

        <!--[if BLOCK]><![endif]--><?php if($error): ?>
            <p class="mt-2 text-sm text-center text-red-500 dark:text-red-400"><?php echo e($error); ?></p>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

        <!-- Hidden Input -->
        <input 
            type="password"
            wire:model="<?php echo e($step === 1 ? 'passcode' : 'confirmPasscode'); ?>"
            maxlength="6"
            class="sr-only"
            inputmode="numeric"
            pattern="[0-9]*"
            autocomplete="off"
            required
        >

        <!-- Number Pad -->
        <div class="mt-[170px] w-full max-w-xs mx-auto">
            <div class="grid grid-cols-3 gap-4">
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = range(1, 9); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $number): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <button 
                        wire:click="addNumber(<?php echo e($number); ?>)"
                        class="w-16 h-16 rounded-full bg-white dark:bg-gray-800 text-gray-800 dark:text-gray-200 text-xl font-medium shadow-lg hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-yellow-500 dark:focus:ring-yellow-500 active:transform active:scale-95 transition-all duration-150"
                    >
                        <?php echo e($number); ?>

                    </button>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                
                <!-- Bottom Row -->
                <button 
                    wire:click="clearPasscode"
                    class="w-16 h-16 rounded-full bg-white dark:bg-gray-800 text-gray-800 dark:text-gray-200 shadow-lg hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-yellow-500 dark:focus:ring-yellow-500 active:transform active:scale-95 transition-all duration-150"
                >
                    <svg class="w-6 h-6 mx-auto" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z" />
                    </svg>
                </button>
                <button 
                    wire:click="addNumber(0)"
                    class="w-16 h-16 rounded-full bg-white dark:bg-gray-800 text-gray-800 dark:text-gray-200 text-xl font-medium shadow-lg hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-yellow-500 dark:focus:ring-yellow-500 active:transform active:scale-95 transition-all duration-150"
                >
                    0
                </button>
                <button 
                    wire:click="deleteNumber"
                    class="w-16 h-16 rounded-full bg-white dark:bg-gray-800 text-gray-800 dark:text-gray-200 shadow-lg hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-yellow-500 dark:focus:ring-yellow-500 active:transform active:scale-95 transition-all duration-150"
                >
                    <svg class="w-6 h-6 mx-auto" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2M3 12l6.414 6.414a2 2 0 001.414.586H19a2 2 0 002-2V7a2 2 0 00-2-2h-8.172a2 2 0 00-1.414.586L3 12z" />
                    </svg>
                </button>
            </div>
        </div>
    </div>
</div>
                    <style>
    /* Fade animations */
    @keyframes fadeIn {
        from { opacity: 0; }
        to { opacity: 1; }
    }

    @keyframes slideUp {
        from { transform: translateY(20px); opacity: 0; }
        to { transform: translateY(0); opacity: 1; }
    }

    @keyframes slideDown {
        from { transform: translateY(-20px); opacity: 0; }
        to { transform: translateY(0); opacity: 1; }
    }

    @keyframes shake {
        0%, 100% { transform: translateX(0); }
        25% { transform: translateX(-5px); }
        75% { transform: translateX(5px); }
    }

    @keyframes pulse {
        0%, 100% { transform: scale(1); }
        50% { transform: scale(1.05); }
    }

    /* Animation classes */
    .animate-fadeIn {
        animation: fadeIn 0.6s ease-out;
    }

    .animate-slideUp {
        opacity: 0;
        animation: slideUp 0.5s ease-out forwards;
    }

    .animate-slideDown {
        opacity: 0;
        animation: slideDown 0.5s ease-out forwards;
    }

    .animate-shake {
        animation: shake 0.5s ease-in-out;
    }

    .animate-pulse {
        animation: pulse 2s cubic-bezier(0.4, 0, 0.6, 1) infinite;
    }

    /* Transition utilities */
    .transition-transform {
        transition-property: transform;
        transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
        transition-duration: 150ms;
    }

    .transition-all {
        transition-property: all;
        transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
        transition-duration: 300ms;
    }

    .delay-150 {
        animation-delay: 150ms;
    }

    /* Focus and active states */
    .focus-ring {
        @apply focus:outline-none focus:ring-2 focus:ring-yellow-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800;
    }

    .active-scale {
        @apply active:transform active:scale-95;
    }
</style>
</div><?php /**PATH /home/blockcino/public_html/resources/views/livewire/auth/passcode-setup.blade.php ENDPATH**/ ?>