<?php if (isset($component)) { $__componentOriginal951024bfcf58033c82ac11d797616473 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal951024bfcf58033c82ac11d797616473 = $attributes; } ?>
<?php $component = App\View\Components\UserLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\UserLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <main class="w-full mx-auto h-auto bg-gray-100 text-gray-900 dark:bg-gray-900 dark:text-white transition-all duration-300 flex flex-col">
        <!-- Header -->
        <div class="flex items-center justify-between p-4">
            <a href="<?php echo e(route('dashboard')); ?>" class="text-gray-400 hover:text-gray-300">
                <i class="fas fa-times text-xl"></i>
            </a>
            <h1 class="text-xl font-semibold">Transaction Sent</h1>
            <div class="w-8"></div> <!-- Spacer for centering -->
        </div>

        <!-- Main Content -->
        <div class="flex-grow flex flex-col items-center justify-center p-4 space-y-6">
            <!-- Success Icon -->
            <div class="w-24 h-24 bg-green-500 rounded-full flex items-center justify-center">
                <i class="fas fa-check text-4xl text-white"></i>
            </div>

            <!-- Success Message -->
            <h2 class="text-2xl font-bold text-center">Transaction Successful!</h2>
            <p class="text-gray-400 text-center">Your funds have been sent successfully.</p>

            <!-- Transaction Details -->
            <div class="w-full max-w-md bg-white dark:bg-gray-800 rounded-lg p-6 space-y-4">
                <div class="flex justify-between">
                    <span class="text-gray-400">Amount Sent</span>
                    <span class="font-semibold"><?php echo e(rtrim(sprintf('%.8f', $transaction->amount_out), '0')); ?> <?php echo e(strtoupper(explode('_', $transaction->which_crypto)[0])); ?></span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-400">Recipient</span>
                    <span class="font-semibold"><?php echo e($transaction->metadata['recipient_name']); ?></span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-400">Network Fee</span>
                    <span class="font-semibold">Free</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-400">Total Amount</span>
                    <span class="font-semibold"><?php echo e(rtrim(sprintf('%.8f', $transaction->amount_out), '0')); ?> <?php echo e(strtoupper(explode('_', $transaction->which_crypto)[0])); ?></span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-400">Date</span>
                    <span class="font-semibold"><?php echo e($transaction->created_at->format('M d, Y H:i:s')); ?></span>
                </div>
            </div>

            <!-- PayID Details -->
            <div class="w-full max-w-md">
                <p class="text-gray-400 text-sm mb-2">Recipient PayID</p>
                <div class="flex items-center justify-between bg-white dark:bg-gray-800 rounded-lg p-3">
                    <span class="text-sm font-mono truncate mr-2"><?php echo e($transaction->metadata['recipient_payid']); ?></span>
                    <button onclick="copyToClipboard('<?php echo e($transaction->metadata['recipient_payid']); ?>')" class="text-yellow-500 hover:text-yellow-400">
                        <i class="far fa-copy"></i>
                    </button>
                </div>
            </div>
        </div>

        <!-- Done Button -->
        <div class="p-4">
            <a href="<?php echo e(route('dashboard')); ?>" 
               class="block w-full bg-yellow-500 hover:bg-yellow-600 text-black font-semibold py-3 px-4 rounded-lg transition-colors text-center">
                Done
            </a>
        </div>
    </main>

    <script>
        function copyToClipboard(text) {
            navigator.clipboard.writeText(text).then(() => {
                // Show success message
                const message = document.createElement('div');
                message.className = 'fixed bottom-4 right-4 bg-green-500 text-white px-4 py-2 rounded shadow-lg';
                message.textContent = 'Copied to clipboard!';
                document.body.appendChild(message);
                
                // Remove message after 2 seconds
                setTimeout(() => {
                    message.remove();
                }, 2000);
            }).catch(() => {
                // Show error message
                const message = document.createElement('div');
                message.className = 'fixed bottom-4 right-4 bg-red-500 text-white px-4 py-2 rounded shadow-lg';
                message.textContent = 'Failed to copy to clipboard';
                document.body.appendChild(message);
                
                // Remove message after 2 seconds
                setTimeout(() => {
                    message.remove();
                }, 2000);
            });
        }
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $attributes = $__attributesOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__attributesOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $component = $__componentOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__componentOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?><?php /**PATH /home/blockcino/public_html/resources/views/user/send/payid-success.blade.php ENDPATH**/ ?>