<?php if (isset($component)) { $__componentOriginal91fdd17964e43374ae18c674f95cdaa3 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3 = $attributes; } ?>
<?php $component = App\View\Components\AdminLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="container px-6 mx-auto">
        <div class="flex justify-between items-center my-6">
            <div>
                <h2 class="text-2xl font-semibold text-gray-700">
                    Transactions
                </h2>
            </div>
            
            <div class="flex items-center space-x-4">
                <button onclick="openTransactionModal()" 
                        class="px-4 py-2 text-sm font-medium text-white bg-purple-600 rounded-lg hover:bg-purple-700 focus:outline-none focus:ring-2 focus:ring-purple-500 focus:ring-offset-2">
                    <i class="ri-add-line mr-2"></i>
                    Create Transaction
                </button>
            </div>
        </div>

        <?php if (isset($component)) { $__componentOriginal6912374916afbfe53350098c2f0b0678 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6912374916afbfe53350098c2f0b0678 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.session-status','data' => ['class' => 'mb-4','status' => session('status'),'errors' => $errors]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('session-status'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'mb-4','status' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(session('status')),'errors' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($errors)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6912374916afbfe53350098c2f0b0678)): ?>
<?php $attributes = $__attributesOriginal6912374916afbfe53350098c2f0b0678; ?>
<?php unset($__attributesOriginal6912374916afbfe53350098c2f0b0678); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6912374916afbfe53350098c2f0b0678)): ?>
<?php $component = $__componentOriginal6912374916afbfe53350098c2f0b0678; ?>
<?php unset($__componentOriginal6912374916afbfe53350098c2f0b0678); ?>
<?php endif; ?>

        <!-- Filters -->
        <div class="bg-white rounded-lg shadow-md p-4 mb-6">
            <form action="<?php echo e(route('admin.transactions')); ?>" method="GET" class="grid gap-4 md:grid-cols-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Type</label>
                    <select name="type" class="w-full rounded-lg border-gray-300 focus:border-purple-500 focus:ring focus:ring-purple-500">
                        <option value="">All Types</option>
                        <?php $__currentLoopData = App\Models\Transaction::getValidTypes(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($type); ?>" <?php echo e(request('type') === $type ? 'selected' : ''); ?>>
                                <?php echo e(ucfirst($type)); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Status</label>
                    <select name="status" class="w-full rounded-lg border-gray-300 focus:border-purple-500 focus:ring focus:ring-purple-500">
                        <option value="">All Statuses</option>
                        <?php $__currentLoopData = App\Models\Transaction::getValidStatuses(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($status); ?>" <?php echo e(request('status') === $status ? 'selected' : ''); ?>>
                                <?php echo e(ucfirst($status)); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Search</label>
                    <input type="text" 
                           name="search" 
                           value="<?php echo e(request('search')); ?>"
                           placeholder="Transaction hash or address..."
                           class="w-full rounded-lg border-gray-300 focus:border-purple-500 focus:ring focus:ring-purple-500">
                </div>

                <div class="flex items-end">
                    <button type="submit" class="px-4 py-2 bg-gray-600 text-white rounded-lg hover:bg-gray-700">
                        <i class="ri-filter-3-line mr-2"></i>Apply Filters
                    </button>
                </div>
            </form>
        </div>

        <!-- Transactions Table -->
<div class="bg-white rounded-lg shadow-md overflow-hidden">
    <div class="overflow-x-auto">
        <table class="w-full whitespace-nowrap">
            <thead>
                <tr class="text-xs font-semibold tracking-wide text-left text-gray-500 uppercase bg-gray-50 border-b">
                    <th class="px-4 py-3">User</th>
                    <th class="px-4 py-3">Type</th>
                    <th class="px-4 py-3">Crypto</th>
                    <th class="px-4 py-3">Amount</th>
                    <th class="px-4 py-3">Status</th>
                    <th class="px-4 py-3">Date</th>
                    <th class="px-4 py-3">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y">
                <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="text-gray-700">
                        <td class="px-4 py-3">
                            <div class="flex items-center">
                                <div class="mr-3 flex-shrink-0">
                                    <div class="h-8 w-8 rounded-full bg-purple-100 flex items-center justify-center">
                                        <span class="text-sm font-medium text-purple-600">
                                            <?php echo e(strtoupper(substr($transaction->user->name, 0, 1))); ?>

                                        </span>
                                    </div>
                                </div>
                                <div>
                                    <p class="font-semibold"><?php echo e($transaction->user->name); ?></p>
                                    <p class="text-xs text-gray-500"><?php echo e($transaction->user->email); ?></p>
                                </div>
                            </div>
                        </td>
                        <td class="px-4 py-3">
                            <span class="text-sm capitalize"><?php echo e($transaction->type); ?></span>
                            <?php if($transaction->isSwap()): ?>
                                <p class="text-xs text-gray-500">
                                    <?php echo e(strtoupper($transaction->from_crypto)); ?> → <?php echo e(strtoupper($transaction->to_crypto)); ?>

                                </p>
                            <?php endif; ?>
                        </td>
                        <td class="px-4 py-3">
                            <span class="text-sm"><?php echo e(strtoupper($transaction->which_crypto)); ?></span>
                        </td>
                        <td class="px-4 py-3">
                            <div class="text-sm">
                                <?php if($transaction->isSwap()): ?>
                                    <span class="text-gray-600">In:</span> <?php echo e(number_format($transaction->amount_in, 8)); ?><br>
                                    <span class="text-gray-600">Out:</span> <?php echo e(number_format($transaction->amount_out, 8)); ?>

                                <?php elseif($transaction->type === 'withdrawal'): ?>
                                    <?php echo e(number_format($transaction->amount_out, 8)); ?>

                                <?php else: ?>
                                    <?php echo e(number_format($transaction->amount_in, 8)); ?>

                                <?php endif; ?>
                            </div>
                        </td>
                        <td class="px-4 py-3">
                            <span class="px-2 py-1 text-xs rounded-full 
                                <?php if($transaction->status === 'completed'): ?> bg-green-100 text-green-800
                                <?php elseif($transaction->status === 'pending'): ?> bg-yellow-100 text-yellow-800
                                <?php elseif($transaction->status === 'failed'): ?> bg-red-100 text-red-800
                                <?php else: ?> bg-gray-100 text-gray-800 <?php endif; ?>">
                                <?php echo e(ucfirst($transaction->status)); ?>

                            </span>
                        </td>
                        <td class="px-4 py-3">
                            <span class="text-sm"><?php echo e($transaction->created_at->format('M d, Y H:i')); ?></span>
                        </td>
                        <td class="px-4 py-3">
                            <div class="flex items-center space-x-2">
                                <?php if($transaction->isPending()): ?>
                                    <button onclick="openApproveModal('<?php echo e($transaction->id); ?>')"
                                            class="p-1 text-green-600 hover:text-green-900 rounded-full hover:bg-green-100">
                                        <i class="ri-check-line text-lg"></i>
                                    </button>
                                    <button onclick="openRejectModal('<?php echo e($transaction->id); ?>')"
                                            class="p-1 text-red-600 hover:text-red-900 rounded-full hover:bg-red-100">
                                        <i class="ri-close-line text-lg"></i>
                                    </button>
                                <?php endif; ?>
                                <button onclick="openDeleteModal('<?php echo e($transaction->id); ?>')"
                                        class="p-1 text-gray-600 hover:text-gray-900 rounded-full hover:bg-gray-100">
                                    <i class="ri-delete-bin-line text-lg"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="px-4 py-8 text-center text-gray-500">
                            No transactions found
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    
    <!-- Pagination -->
    <div class="px-4 py-3 border-t">
        <?php echo e($transactions->links()); ?>

    </div>
</div>

    <!-- Include the Transaction Modal here -->
    <?php echo $__env->make('admin.transactions.modals.create', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Approve Modal -->
    <div id="approveModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden">
        <div class="flex items-center justify-center min-h-screen px-4">
            <div class="bg-white rounded-lg shadow-xl max-w-md w-full">
                <div class="p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Approve Transaction</h3>
                    <form id="approveForm" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <p class="mb-4 text-gray-600">Are you sure you want to approve this transaction?</p>
                        <div class="flex justify-end space-x-3">
                            <button type="button" onclick="closeApproveModal()"
                                    class="px-4 py-2 text-sm font-medium text-gray-700 bg-gray-100 rounded-lg hover:bg-gray-200">
                                Cancel
                            </button>
                            <button type="submit"
                                    class="px-4 py-2 text-sm font-medium text-white bg-green-600 rounded-lg hover:bg-green-700">
                                Approve
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Reject Modal -->
    <div id="rejectModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden">
        <div class="flex items-center justify-center min-h-screen px-4">
            <div class="bg-white rounded-lg shadow-xl max-w-md w-full">
                <div class="p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Reject Transaction</h3>
                    <form id="rejectForm" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="mb-4">
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Reason for Rejection
                            </label>
                            <textarea name="reason" rows="3"
                                      class="w-full rounded-lg border-gray-300 focus:border-purple-500 focus:ring focus:ring-purple-500"
                                      required></textarea>
                        </div>
                        <div class="flex justify-end space-x-3">
                            <button type="button" onclick="closeRejectModal()"
                                    class="px-4 py-2 text-sm font-medium text-gray-700 bg-gray-100 rounded-lg hover:bg-gray-200">
                                Cancel
                            </button>
                            <button type="submit"
                                    class="px-4 py-2 text-sm font-medium text-white bg-red-600 rounded-lg hover:bg-red-700">
                                Reject
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Modal -->
    <div id="deleteModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden">
        <div class="flex items-center justify-center min-h-screen px-4">
            <div class="bg-white rounded-lg shadow-xl max-w-md w-full">
                <div class="p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Delete Transaction</h3>
                    <form id="deleteForm" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <p class="mb-4 text-gray-600">Are you sure you want to delete this transaction? This action cannot be undone.</p>
                        <div class="flex justify-end space-x-3">
                            <button type="button" onclick="closeDeleteModal()"
                                    class="px-4 py-2 text-sm font-medium text-gray-700 bg-gray-100 rounded-lg hover:bg-gray-200">
                                Cancel
                            </button>
                            <button type="submit"
                                    class="px-4 py-2 text-sm font-medium text-white bg-red-600 rounded-lg hover:bg-red-700">
                                Delete
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Modal Functions
        function openApproveModal(id) {
            const modal = document.getElementById('approveModal');
            const form = document.getElementById('approveForm');
            form.action = `/admin/transactions/${id}/approve`;
            modal.classList.remove('hidden');
        }

        function closeApproveModal() {
            document.getElementById('approveModal').classList.add('hidden');
        }

        function openRejectModal(id) {
            const modal = document.getElementById('rejectModal');
            const form = document.getElementById('rejectForm');
            form.action = `/admin/transactions/${id}/reject`;
            modal.classList.remove('hidden');
        }

        function closeRejectModal() {
            document.getElementById('rejectModal').classList.add('hidden');
        }

        function openDeleteModal(id) {
            const modal = document.getElementById('deleteModal');
            const form = document.getElementById('deleteForm');
            form.action = `/admin/transactions/${id}`;
            modal.classList.remove('hidden');
        }

        function closeDeleteModal() {
            document.getElementById('deleteModal').classList.add('hidden');
        }
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $attributes = $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $component = $__componentOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?><?php /**PATH /home/blockcino/public_html/resources/views/admin/transactions/index.blade.php ENDPATH**/ ?>