<?php if(session('error_code') === 'SENDING_DISABLED'): ?>
    <div class="bg-yellow-50 border-l-4 border-yellow-400 p-4 mb-4">
        <div class="flex">
            <div class="flex-shrink-0">
                <i class="fas fa-exclamation-triangle text-yellow-400"></i>
            </div>
            <div class="ml-3">
                <p class="text-sm text-yellow-700">
                    <?php echo e(session('error')); ?>

                </p>
                <div class="mt-3">
                    <a href="#" onclick="showSupportModal()" 
                       class="text-sm font-medium text-yellow-700 hover:text-yellow-600">
                        Contact Support <span aria-hidden="true">&rarr;</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <!-- Support Modal -->
    <div id="supportModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden z-50">
        <div class="bg-white dark:bg-gray-900 w-full max-w-md rounded-lg p-6 mx-4">
            <div class="text-center mb-6">
                <div class="w-16 h-16 bg-yellow-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-headset text-yellow-500 text-2xl"></i>
                </div>
                <h2 class="text-2xl font-bold mb-2">Contact Support</h2>
                <p class="text-gray-500 dark:text-gray-400">
                    To enable crypto sending, please contact our support team. They will assist you with the verification process.
                </p>
            </div>
            <div class="space-y-4">
                <a href="mailto:<?php echo e(setting('company_email', 'support@example.com')); ?>" 
                   class="w-full flex items-center p-4 bg-gray-50 dark:bg-gray-800 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700">
                    <i class="fas fa-envelope text-gray-400 mr-3"></i>
                    <div class="flex-1">
                        <div class="font-medium">Email Support</div>
                        <div class="text-sm text-gray-500 dark:text-gray-400"><?php echo e(setting('company_email', 'support@example.com')); ?></div>
                    </div>
                    <i class="fas fa-chevron-right text-gray-400"></i>
                </a>
            </div>
            <button onclick="hideSupportModal()" 
                    class="w-full mt-6 px-4 py-2 bg-gray-200 dark:bg-gray-700 text-gray-700 dark:text-gray-300 rounded-lg hover:bg-gray-300 dark:hover:bg-gray-600">
                Close
            </button>
        </div>
    </div>
    <script>
        function showSupportModal() {
            document.getElementById('supportModal').classList.remove('hidden');
        }
        function hideSupportModal() {
            document.getElementById('supportModal').classList.add('hidden');
        }
        // Close modal when clicking outside
        window.onclick = function(event) {
            const modal = document.getElementById('supportModal');
            if (event.target === modal) {
                modal.classList.add('hidden');
            }
        }
    </script>
<?php endif; ?><?php /**PATH /home/cypherva/public_html/resources/views/user/status/index.blade.php ENDPATH**/ ?>