<?php

use App\Http\Controllers\User\ProfileController;
use App\Http\Controllers\User\SwapController;
use App\Http\Controllers\User\DepositController;
use App\Http\Controllers\User\WithdrawController;
use App\Http\Controllers\User\BotController;
use App\Http\Controllers\User\CardController;
use App\Http\Controllers\User\SettingsController;
use App\Http\Controllers\User\CryptoController;
use App\Http\Controllers\User\ReferralController;
use App\Http\Controllers\User\BuyController;
use App\Http\Controllers\User\ReceiveController;
use App\Http\Controllers\User\SendController;
use App\Http\Controllers\User\NotificationController;
use App\Http\Controllers\User\KycController;
use App\Http\Controllers\User\WalletController;
use App\Http\Controllers\Auth\ForgotPasswordController;
use App\Http\Controllers\Auth\ResetPasswordController;
use App\Livewire\Auth\PasscodePage;
use App\Livewire\Auth\PasscodeSetup;
use App\Livewire\User\Dashboard;
use App\Http\Middleware\VerifyPasscode;

	Route::middleware(['auth', 'verified', VerifyPasscode::class])->group(function () {
    Route::get('/dashboard', Dashboard::class)->name('dashboard');
    
    Route::prefix('referral')->group(function () {
    Route::get('/', [ReferralController::class, 'index'])->name('referral.index');
    Route::get('/stats', [ReferralController::class, 'stats'])->name('referral.stats');
    });

    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
   
    Route::get('/swap', [SwapController::class, 'index'])->name('swap');
    Route::post('/swap/process', [SwapController::class, 'swap'])->name('swap.process');
    
    Route::get('/deposit', [DepositController::class, 'index'])->name('deposit');
    Route::get('/withdraw', [WithdrawController::class, 'index'])->name('withdraw');
    Route::get('/settings', [SettingsController::class, 'index'])->name('settings');
    
    Route::prefix('crypto')->group(function () {
    Route::get('/details/{symbol}/{network?}', [CryptoController::class, 'details'])->name('crypto.details');
    Route::get('/manage', [CryptoController::class, 'manage'])->name('crypto.manage');
    Route::post('/crypto/update', [CryptoController::class, 'updateManage'])->name('crypto.manage.update');
    Route::get('/address', [CryptoController::class, 'address'])->name('crypto.address');
	});

	Route::prefix('buy')->group(function () {
    Route::get('/', [BuyController::class, 'index'])->name('buy.index');
    Route::get('/details/{symbol}/{network?}', [BuyController::class, 'details'])->name('buy.details');
	});
	
	Route::prefix('card')->group(function () {
    Route::get('/', [CardController::class, 'index'])->name('card.index');
    Route::post('/request', [CardController::class, 'request'])->name('card.request');
    Route::get('/add-money', [CardController::class, 'addMoney'])->name('card.add-money');
    Route::post('/fund', [CardController::class, 'fund'])->name('card.fund');
    Route::post('/{card}/freeze', [CardController::class, 'freeze'])->name('card.freeze');
    Route::post('/{card}/unfreeze', [CardController::class, 'unfreeze'])->name('card.unfreeze');
    Route::delete('/{card}', [CardController::class, 'delete'])->name('card.delete');
    });
	
    Route::get('/bots', [BotController::class, 'index'])->name('bots');
    Route::get('/bots/show', [BotController::class, 'show'])->name('bots.show');
	Route::post('/bots/subscribe', [BotController::class, 'subscribe'])->name('bots.subscribe');
    Route::get('/bots/history', [BotController::class, 'history'])->name('bots.history');
    Route::get('/bots/trades/update', [BotController::class, 'updateTrades'])->name('bots.trades.update');
    
    
    Route::prefix('send')->middleware(['auth'])->group(function () {
    // PayID Routes
    Route::get('/payid', [SendController::class, 'payidAssets'])->name('send.payid');
    Route::get('/payid/{symbol}/{network?}', [SendController::class, 'payidDetails'])->name('send.payid.details');
    Route::post('/payid/verify', [SendController::class, 'verifyPayId'])->name('send.payid.verify');
    Route::post('/send/payid/process/{symbol}/{network?}', [SendController::class, 'processPayId'])
        ->name('send.payid.process');
    
    Route::get('/payid/{symbol}/{network?}/success/{transaction}', [SendController::class, 'success'])->name('send.payid.success');
    Route::get('/payid/{symbol}/{network?}/failed', [SendController::class, 'failed'])->name('send.payid.failed');
    
    // External Routes
    Route::get('/external', [SendController::class, 'externalAssets'])->name('send.external');
    Route::get('/external/{symbol}/{network?}', [SendController::class, 'externalDetails'])->name('send.external.details');
    Route::post('/external/verify', [SendController::class, 'verifyExternal'])->name('send.external.verify');
    Route::post('/send/external/process/{symbol}/{network?}', [SendController::class, 'processExternal'])
        ->name('send.external.process');
    
    Route::get('/external/{symbol}/{network?}/success/{transaction}', [SendController::class, 'externalSuccess'])->name('send.external.success');
    Route::get('/external/{symbol}/{network?}/failed', [SendController::class, 'externalFailed'])->name('send.external.failed');
    });


	Route::prefix('receive')->group(function () {
    Route::get('/payid', [ReceiveController::class, 'payidAssets'])->name('receive.payid');
    Route::get('/payid/{symbol}/{network?}', [ReceiveController::class, 'payidDetails'])->name('receive.payid.details');
    Route::get('/external', [ReceiveController::class, 'externalAssets'])->name('receive.external');
    Route::get('/external/{symbol}/{network?}', [ReceiveController::class, 'externalDetails'])->name('receive.external.details');
	});

   
    Route::get('/notifications', [NotificationController::class, 'index'])->name('notifications');
    Route::post('/notifications/{id}/read', [NotificationController::class, 'markAsRead']);
    Route::delete('/notifications/{id}', [NotificationController::class, 'destroy']);
    Route::post('/notifications/mark-all-read', function() {
        auth()->user()->notifications()->update(['is_read' => true]);
        return response()->json(['success' => true]);
    });
    Route::get('/notifications/unread-count', [NotificationController::class, 'unreadCount']);
    
	Route::get('/kyc', [KycController::class, 'index'])->name('kyc');
    Route::post('/kyc/upload', [KycController::class, 'uploadDocuments'])->name('user.kyc.upload');
    Route::get('/kyc/status', [KycController::class, 'getDocumentStatus'])->name('user.kyc.status');
    
    // Wallet connection route
    Route::post('/api/wallet/connect', [WalletController::class, 'connect'])->name('wallet.connect');
	});

	Route::middleware(['auth', 'verified'])->group(function () {
    Route::get('/passcode', PasscodePage::class)->name('passcode.show');
    Route::get('/passcode/setup', PasscodeSetup::class)->name('passcode.setup');
	});

    // Forgot Password Routes
Route::get('forgot-password', [ForgotPasswordController::class, 'showLinkRequestForm'])->name('password.request');
Route::post('forgot-password', [ForgotPasswordController::class, 'sendResetLinkEmail'])->name('password.email');

// Reset Password Routes
Route::get('reset-password/{token}', [ResetPasswordController::class, 'showResetForm'])->name('password.reset');
Route::post('reset-password', [ResetPasswordController::class, 'reset'])->name('password.update');