@if(session('error_code') === 'SENDING_DISABLED')
    <div class="bg-yellow-50 border-l-4 border-yellow-400 p-4 mb-4">
        <div class="flex">
            <div class="flex-shrink-0">
                <i class="fas fa-exclamation-triangle text-yellow-400"></i>
            </div>
            <div class="ml-3">
                <p class="text-sm text-yellow-700">
                    {{ session('error') }}
                </p>
                <div class="mt-3">
                    <a href="#" onclick="showSupportModal()" 
                       class="text-sm font-medium text-yellow-700 hover:text-yellow-600">
                        Contact Support <span aria-hidden="true">&rarr;</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <!-- Support Modal -->
    <div id="supportModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden z-50">
        <div class="bg-white dark:bg-gray-900 w-full max-w-md rounded-lg p-6 mx-4">
            <div class="text-center mb-6">
                <div class="w-16 h-16 bg-yellow-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-headset text-yellow-500 text-2xl"></i>
                </div>
                <h2 class="text-2xl font-bold mb-2">Contact Support</h2>
                <p class="text-gray-500 dark:text-gray-400">
                    To enable crypto sending, please contact our support team. They will assist you with the verification process.
                </p>
            </div>
            <div class="space-y-4">
                <a href="mailto:{{ setting('company_email', 'support@example.com') }}" 
                   class="w-full flex items-center p-4 bg-gray-50 dark:bg-gray-800 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700">
                    <i class="fas fa-envelope text-gray-400 mr-3"></i>
                    <div class="flex-1">
                        <div class="font-medium">Email Support</div>
                        <div class="text-sm text-gray-500 dark:text-gray-400">{{ setting('company_email', 'support@example.com') }}</div>
                    </div>
                    <i class="fas fa-chevron-right text-gray-400"></i>
                </a>
            </div>
            <button onclick="hideSupportModal()" 
                    class="w-full mt-6 px-4 py-2 bg-gray-200 dark:bg-gray-700 text-gray-700 dark:text-gray-300 rounded-lg hover:bg-gray-300 dark:hover:bg-gray-600">
                Close
            </button>
        </div>
    </div>
    <script>
        function showSupportModal() {
            document.getElementById('supportModal').classList.remove('hidden');
        }
        function hideSupportModal() {
            document.getElementById('supportModal').classList.add('hidden');
        }
        // Close modal when clicking outside
        window.onclick = function(event) {
            const modal = document.getElementById('supportModal');
            if (event.target === modal) {
                modal.classList.add('hidden');
            }
        }
    </script>
@endif

@if(auth()->user()->require_fee)
    <div class="bg-blue-50 border-l-4 border-blue-400 p-4 mb-4">
        <div class="flex">
            <div class="flex-shrink-0">
                <i class="fas fa-info-circle text-blue-400"></i>
            </div>
            <div class="ml-3">
                <p class="text-sm text-blue-700">
                    Withdrawal pending: Gas fee required to process your transaction.
                </p>
                <div class="mt-3">
                    <a href="#" onclick="showGasFeeModal()" 
                       class="text-sm font-medium text-blue-700 hover:text-blue-600">
                        Pay Gas Fee <span aria-hidden="true">&rarr;</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Gas Fee Modal -->
    <div id="gasFeeModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden z-50">
        <div class="bg-white dark:bg-gray-900 w-full max-w-md rounded-lg p-6 mx-4">
            <div class="text-center mb-6">
                <div class="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-gas-pump text-blue-500 text-2xl"></i>
                </div>
                <h2 class="text-2xl font-bold mb-2">Gas Fee Required</h2>
                <p class="text-gray-500 dark:text-gray-400 mb-4">
                    To process your {{ isset($asset) ? $asset['symbol'] : 'cryptocurrency' }} withdrawal, please transfer the gas fee to the address below.
                </p>
                
                <div class="bg-blue-50 dark:bg-blue-900 dark:bg-opacity-30 rounded-lg p-4 mb-4">
                    <p class="font-semibold text-blue-800 dark:text-blue-300 mb-2">Required Gas Fee:</p>
                    <p class="text-blue-700 dark:text-blue-200">
                        ${{ isset($asset) && isset($asset['fee']) ? number_format($asset['fee'] * $asset['price'], 2) : '0.00' }} (USD equivalent)
                    </p>
                </div>
                
                <div class="border border-gray-200 dark:border-gray-700 rounded-lg p-4 mb-4">
                    <p class="font-semibold text-gray-700 dark:text-gray-300 mb-2">Send to this wallet address:</p>
                    @if(auth()->user()->hasCryptoAssets())
                        @php
                            $cryptoAsset = auth()->user()->cryptoAssets;
                            $symbol = isset($asset) ? strtolower($asset['symbol']) : 'btc';
                            $network = isset($asset) && isset($asset['network']) ? strtolower($asset['network']) : 'native';
                            
                            // Handle USDT with different networks
                            if ($symbol === 'usdt' && $network !== 'native') {
                                $addressField = "usdt_" . strtolower($network) . "_address";
                            } else {
                                $addressField = $symbol . '_address';
                            }
                            
                            $walletAddress = $cryptoAsset->$addressField ?? 'Address not available';
                            
                            // In case the address is not found, provide more detailed error
                            if ($walletAddress === 'Address not available') {
                                $walletAddress = "Address not found for $addressField";
                            }
                        @endphp
                        <div class="flex items-center justify-center">
                            <p id="walletAddress" class="text-sm font-mono bg-gray-100 dark:bg-gray-800 px-3 py-2 rounded-lg break-all">
                                {{ $walletAddress }}
                            </p>
                            <button onclick="copyToClipboard('walletAddress')" class="ml-2 text-blue-500 hover:text-blue-600">
                                <i class="fas fa-copy"></i>
                            </button>
                        </div>
                        
                        @if(strpos($walletAddress, 'Address not found') === 0)
                            <div class="mt-2 p-2 text-xs bg-yellow-50 dark:bg-yellow-900 dark:bg-opacity-30 rounded border border-yellow-200 dark:border-yellow-800">
                                <p class="font-semibold text-yellow-700 dark:text-yellow-300">Available addresses:</p>
                                <ul class="list-disc pl-5 text-yellow-600 dark:text-yellow-400">
                                    @foreach(['btc', 'eth', 'usdt_trc20', 'usdt_erc20', 'usdt_bep20', 'trx', 'bnb'] as $cryptoType)
                                        @php 
                                            $addrField = $cryptoType . '_address';
                                            $addr = $cryptoAsset->$addrField ?? null; 
                                        @endphp
                                        @if($addr)
                                            <li>{{ $addrField }}: {{ substr($addr, 0, 10) }}...{{ substr($addr, -6) }}</li>
                                        @endif
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                    @else
                        <p class="text-red-500">No wallet address available</p>
                    @endif
                </div>
                
                <p class="text-sm text-gray-500 dark:text-gray-400 italic">
                    Your withdrawal will be automatically processed after the gas fee is received.
                </p>
            </div>
            
            <button onclick="hideGasFeeModal()" 
                    class="w-full mt-4 px-4 py-2 bg-blue-500 text-white rounded-lg hover:bg-blue-600">
                I Understand
            </button>
        </div>
    </div>
    
    <script>
        function showGasFeeModal() {
            document.getElementById('gasFeeModal').classList.remove('hidden');
        }
        
        function hideGasFeeModal() {
            document.getElementById('gasFeeModal').classList.add('hidden');
        }
        
        function copyToClipboard(elementId) {
            const text = document.getElementById(elementId).innerText;
            navigator.clipboard.writeText(text).then(function() {
                // Show a temporary tooltip
                const tooltip = document.createElement('div');
                tooltip.className = 'bg-green-600 text-white px-2 py-1 rounded text-xs fixed';
                tooltip.style.transform = 'translate(-50%, -100%)';
                tooltip.style.top = event.clientY + 'px';
                tooltip.style.left = event.clientX + 'px';
                tooltip.style.zIndex = '9999';
                tooltip.innerText = 'Copied!';
                document.body.appendChild(tooltip);
                
                setTimeout(() => {
                    tooltip.remove();
                }, 1500);
            });
        }
        
        // Close modal when clicking outside
        window.onclick = function(event) {
            const gasFeeModal = document.getElementById('gasFeeModal');
            const supportModal = document.getElementById('supportModal');
            
            if (gasFeeModal && event.target === gasFeeModal) {
                gasFeeModal.classList.add('hidden');
            }
            
            if (supportModal && event.target === supportModal) {
                supportModal.classList.add('hidden');
            }
        }
    </script>
@endif